<?php

namespace WPDesk\FCF\Pro\Validator\Rule;

use WPDesk\FCF\Pro\Field\Attr\DateFormatAttr;
use WPDesk\FCF\Pro\Settings\Option\DateFormatOption;
use WPDesk\FCF\Pro\Validator\Error\InvalidDateFormatError;

/**
 * Checks that the date format is valid.
 */
class DateFormatRule implements ValidatorRule {

	/**
	 * {@inheritdoc}
	 */
	public function validate_value( string $value, array $field_data ) {
		$date_format = $field_data[ DateFormatOption::FIELD_NAME ] ?? null;
		if ( ! $date_format ) {
			return null;
		}

		$valid_format = DateFormatAttr::convert_date_format_for_php( $date_format );
		$dates        = ( $value ) ? explode( ',', $value ) : [];
		foreach ( $dates as $date ) {
			if ( gmdate( $valid_format, strtotime( $date ) ) !== $date ) {
				return new InvalidDateFormatError( $field_data, $value );
			}
		}

		return null;
	}
}
